﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int lteEtTest(string standard)
        {
            // Configure variables for LTE FDD 5 MHZ BW Standard
            string testWaveform = "";
            string testName = "";
            string etFileName = "";
            //double iqDelay = 0;
            switch (standard)
            {
                case "B5M":
                    testWaveform = lte5MhzArb;
                    etFileName = lte5MhzEtArb;
                    iqDelay = 213e-9;
                    testName = "LTE FDD 5 MHz Test";
                    vsag.setupParameters("LTE_FDD_5MHZ");
                    dataLog.tstName = "LTE 5";
                    break;
                case "B10M":
                    testWaveform = lte10MhzArb;
                    etFileName = lte10MhzEtArb;
                    iqDelay = 183e-9;
                    testName = "LTE FDD 10 MHz Test";
                    vsag.setupParameters("LTE_FDD_10MHZ");
                    dataLog.tstName = "LTE 10";
                    break;
                case "B20M":
                    testWaveform = lte20MhzArb;
                    etFileName = lte20MhzEtArb;
                    iqDelay = 172e-9;
                    testName = "LTE FDD 20 MHz Test";
                    vsag.setupParameters("LTE_FDD_20MHZ");
                    dataLog.tstName = "LTE 20";
                    break;
            }

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL");

            // Configuration for ET:
            // 1.  Stop RF AWG Playback
            // 2.  Start ET AWG playback with External Trigger
            // 3.  Start RF AWG on 10 MHz clock edge using Baseband Delay to adjust timing
            vsag.stopModulation();
            //if (Lib.use33522B)
            //{
            //    arbGain = 0.432;
            //    arbOffset = 0.44;
            //}
            etArb.startAwgWaveformTriggered(etFileName, arbAmplitude, arbOffset, 0.0, true);
            // Setup the VSG and VSA for waveform, band frequency and power level
            vsag.setVsgIqDelay(iqDelay);
            vsag.setupVsgVsa(testWaveform, cellFreqs[frequencyIndex], targetPout, targetGain);

            // Set VSG and VSA to test frequency
            vsag.setTestFreq(cellFreqs[frequencyIndex]);

            // Servo source until Pout is at correct value
            if (vsag.fftServo)
                vsag.servoInputPowerFft(targetPout, poutMargin);
            else
                vsag.servoInputPower(targetPout, poutMargin);

            if (true)
            {
                // Make sure the iqDelay does not go outside the +/- 250 ns Range
                double startIqDelay = Math.Max((iqDelay - iqRange), -250e-9);
                double stopIqDelay = Math.Min((iqDelay + iqRange), 250e-9);
                double thisIqDelay = startIqDelay;
                while (thisIqDelay <= stopIqDelay)
                {
                    vsag.setVsgIqDelay(thisIqDelay, true);
                    if (dataLog.updateResultWindow)
                        dataLog.addResultsHeader("IQ Delay = " + Math.Round(thisIqDelay*1e9).ToString() + "ns");
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                    {
                        vsag.measPoutFft();
                        vsag.measLteFftAcpr();
                    }
                    else
                        vsag.measLteAcpr();
                    thisIqDelay += iqStep;
                    // We are using the measACPR array to build the graph in the Debug program
                    // Need to call "nextTest" to increment the testIndex and then 
                    // set the Channel power for the new testIndex for correct ACPR calulation 
                    dataLog.nextTest();
                    dataLog.chanPower[dataLog.testIndex] = dataLog.chanPower[dataLog.testIndex - 1];
                }
            }

            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}